// Generated by CoffeeScript 1.10.0
(function() {
  var Vomnibar, root;

  Vomnibar = {
    vomnibarUI: null,
    parseRegistryEntry: function(registryEntry, callback) {
      var options, ref, searchEngines;
      if (registryEntry == null) {
        registryEntry = {
          options: []
        };
      }
      if (callback == null) {
        callback = null;
      }
      options = {};
      searchEngines = (ref = Settings.get("searchEngines")) != null ? ref : "";
      return SearchEngines.refreshAndUse(searchEngines, function(engines) {
        var i, key, len, option, ref1, ref2, value;
        ref1 = registryEntry.options;
        for (i = 0, len = ref1.length; i < len; i++) {
          option = ref1[i];
          ref2 = option.split("="), key = ref2[0], value = ref2[1];
          switch (key) {
            case "keyword":
              if ((value != null) && (engines[value] != null)) {
                options.keyword = value;
              } else {
                console.log("Vimium configuration error: no such custom search engine: " + option + ".");
              }
              break;
            default:
              console.log("Vimium configuration error: unused flag: " + option + ".");
          }
        }
        return typeof callback === "function" ? callback(options) : void 0;
      });
    },
    activate: function(sourceFrameId, registryEntry) {
      return this.parseRegistryEntry(registryEntry, (function(_this) {
        return function(options) {
          return _this.open(sourceFrameId, extend(options, {
            completer: "omni"
          }));
        };
      })(this));
    },
    activateInNewTab: function(sourceFrameId, registryEntry) {
      return this.parseRegistryEntry(registryEntry, (function(_this) {
        return function(options) {
          return _this.open(sourceFrameId, extend(options, {
            completer: "omni",
            newTab: true
          }));
        };
      })(this));
    },
    activateTabSelection: function(sourceFrameId) {
      return this.open(sourceFrameId, {
        completer: "tabs",
        selectFirst: true
      });
    },
    activateBookmarks: function(sourceFrameId) {
      return this.open(sourceFrameId, {
        completer: "bookmarks",
        selectFirst: true
      });
    },
    activateBookmarksInNewTab: function(sourceFrameId) {
      return this.open(sourceFrameId, {
        completer: "bookmarks",
        selectFirst: true,
        newTab: true
      });
    },
    activateEditUrl: function(sourceFrameId) {
      return this.open(sourceFrameId, {
        completer: "omni",
        selectFirst: false,
        query: window.location.href
      });
    },
    activateEditUrlInNewTab: function(sourceFrameId) {
      return this.open(sourceFrameId, {
        completer: "omni",
        selectFirst: false,
        query: window.location.href,
        newTab: true
      });
    },
    init: function() {
      if (this.vomnibarUI == null) {
        this.vomnibarUI = new UIComponent("pages/vomnibar.html", "vomnibarFrame", (function(_this) {
          return function(event) {
            if (event.data === "hide") {
              return _this.vomnibarUI.hide();
            }
          };
        })(this));
        return window.addEventListener("focus", (function(_this) {
          return function(event) {
            if (event.target === window) {
              _this.vomnibarUI.postMessage("hidden");
            }
            return true;
          };
        })(this));
      }
    },
    open: function(sourceFrameId, options) {
      return this.vomnibarUI.activate(extend(options, {
        sourceFrameId: sourceFrameId
      }));
    }
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.Vomnibar = Vomnibar;

}).call(this);
